/*
 *  Envlink File System, version 0.3, 01.02.1999
 * 
 *  envlinkfs/env.c
 *
 *  Copyright (C) 1998-1999 by Stelian Pop <pop@cybercable.fr>
 *
 *  some parts hacked from linux/drivers/block/floppy.c:
 *        Copyright (C) 1991, 1992  Linus Torvalds
 *        Copyright (C) 1993, 1994  Alain Knaff
 *        and others...
 *
 */

#include <linux/types.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <asm/segment.h>
#include <asm/uaccess.h>

#include "envlinkfs.h"

/*
 * Puts the value of the environment variable 'key' into 'value'.
 * Returns 0 on success, -1 on failure
 */
static int
envlinkfs_getenv(char *key, char *value, int valuelen)
{
	unsigned long i;
	char c;
	int j=1;
	int match=0;
	char *buffer=kmalloc(4096, GFP_KERNEL);
	int length=strlen(key)+1;

	for (i=current->mm->env_start; i< current->mm->env_end; i ++){
		get_user(c, (char *)i);
		if (match){
			if (j==4095)
				c='\0';
			buffer[j] = c;
			if (!c || c == ' ' || c == '\t'){
				if (j){
					buffer[j] = '\0';
					if (valuelen > j + 1)
						valuelen = j + 1;
					if (valuelen < 1)	
						valuelen = 1;
					memcpy(value, buffer+1, valuelen-1);
					kfree(buffer);
					return 0;
				}
				j=0;
			} else
				j++;
			if (!c)
				break;
			continue;
		}
		if ((!j && !c) || (j && c == key[j-1]))
			j++;
		else
			j=0;
		if (j==length){
			match=1;
			j=0;
		}
	}
	kfree(buffer);
	return -1;
}

/*
 * If test=1, does the same as envlinkfs_get_env.
 * If test=0, returns the key itself.
 */
int
envlinkfs_getenv_if(char *key, char *value, int valuelen, int test)
{
	if (test)
		return envlinkfs_getenv(key, value, valuelen);
	memcpy(value, key, (valuelen > strlen(key) + 1) ? strlen(key) + 1 : valuelen);
	return 0;
}

/*
 * Same as envlinkfs_getenv_if, but the value is just tested, it is not copied.
 */
int 
envlinkfs_envexists_if(char *key, int test)
{
	if (test)
		return envlinkfs_getenv(key, NULL, 0);
	return 0;
}
